/**HEADER********************************************************************
* 
* Copyright (c) 2012 Freescale Semiconductor;
* All Rights Reserved
*
*************************************************************************** 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************
*
* $FileName: fxlc9550eval.h$
* $Version : 1.0.0.0$
* $Date    : Feb-24-2012$
*
* Comments:
*
*   This include file is used to provide information needed by
*   an application program using the kernel running on the
*   Freescale Fxlc95000 Evaluation board.
*
*END************************************************************************/

#ifndef _fxlc9550eval_h_
#define _fxlc9550eval_h_ 1

/*
** Get MQX configuration (also gets user_config.h)
*/
#include "mqx_cnfg.h"

#ifdef __cplusplus
extern "C" {
#endif

/*----------------------------------------------------------------------
**                  HARDWARE INITIALIZATION DEFINITIONS
*/

/*
** Define the board type
*/
#define BSP_FXLC95000EVAL 1		// Gets used in ..\mqx\examples\spi\memory.h

/*
** PROCESSOR MEMORY BOUNDS
*/
// These constants are defined in the intflash.lcf linker file. hht 	
extern uchar __INTERNAL_SRAM_BASE[],  __INTERNAL_SRAM_SIZE[];
extern uchar __INTERNAL_FLASH_BASE[], __INTERNAL_FLASH_SIZE[];
extern uchar __EXTERNAL_MRAM_BASE[],  __EXTERNAL_MRAM_SIZE[];
extern uchar __EXTERNAL_MRAM_ROM_BASE[],  __EXTERNAL_MRAM_ROM_SIZE[];
extern uchar __EXTERNAL_MRAM_RAM_BASE[],  __EXTERNAL_MRAM_RAM_SIZE[];

#define BSP_IPSBAR                  ((uint_32)0xFFFF8000) // peripherals memory
#define BSP_INTERNAL_SRAM_BASE      ((pointer)__INTERNAL_SRAM_BASE)
#define BSP_INTERNAL_SRAM_SIZE      ((uint_32)__INTERNAL_SRAM_SIZE)
#define BSP_INTERNAL_FLASH_BASE     ((pointer)__INTERNAL_FLASH_BASE)
#define BSP_INTERNAL_FLASH_SIZE     ((uint_32)__INTERNAL_FLASH_SIZE)
#define BSP_EXTERNAL_MRAM_BASE      ((pointer)__EXTERNAL_MRAM_BASE)
#define BSP_EXTERNAL_MRAM_SIZE      ((uint_32)__EXTERNAL_MRAM_SIZE)
#define BSP_EXTERNAL_MRAM_ROM_BASE  ((pointer)__EXTERNAL_MRAM_ROM_BASE)
#define BSP_EXTERNAL_MRAM_ROM_SIZE  ((uint_32)__EXTERNAL_MRAM_ROM_SIZE)
#define BSP_EXTERNAL_MRAM_RAM_BASE  ((pointer)__EXTERNAL_MRAM_RAM_BASE)
#define BSP_EXTERNAL_MRAM_RAM_SIZE  ((uint_32)__EXTERNAL_MRAM_RAM_SIZE)


// --------------------------------
/*
** The timer MQX uses
*/
#define BSP_TIMER_USE_TPM                             1
#define BSP_TIMER_USE_PDB                             2

//#define BSP_TIMER                                     BSP_TIMER_USE_TPM
#define BSP_TIMER                                     BSP_TIMER_USE_PDB


// --------------------------------
// Initial timing settings at startup.

// Frame rate setting.
  #define BSP_INITIAL_FLE                               8 // Valid: 4-18



#if (BSP_TIMER == BSP_TIMER_USE_PDB)
  #define BSP_INITIAL_TICK_PERIOD_NSEC                  (1 * 1000 * 1000) // Default 1ms

  #define BSP_MAXIMUM_TICK_PERIOD_NSEC                  (100 * 1000 * 1000)  // Max 100 ms
  #define BSP_MINIMUM_TICK_PERIOD_NSEC                  (100 * 1000)           // Min 100 usec
  
#endif


#if (BSP_TIMER == BSP_TIMER_USE_TPM)
  // Main setting for rtos tick for TPM timer.
  #define BSP_RTOS_CLK_PERIOD_USEC                          (1000)                     
  #define BSP_RTOS_TICKS_PER_SEC                            ((1000 * 1000) / BSP_RTOS_CLK_PERIOD_USEC)
#endif


// --------------------------------
/*
** CLKIN speed
*/
#define BSP_SYSTEM_CLOCK_HZ                                 (16000000L)
#define BSP_BUS_CLOCK_HZ                                    (BSP_SYSTEM_CLOCK_HZ/1) // For Fxlcxxxx, bus clk = sys clk.


#define BSP_BUS_CLOCK_PERIOD_PICOSEC                        (1000000000/(BSP_BUS_CLOCK_HZ/1000))
#define BSP_BUS_CLOCK_PERIOD_100PICOSEC                     (1000000000/(BSP_BUS_CLOCK_HZ/10))
#if (BSP_BUS_CLOCK_PERIOD_PICOSEC > (512 * 1000))
  // 512000 picosec or 512 nanosec is 1.953 Mhz
  #warning Value is larger than 512000 picosec.  This will cause overflow in _fxlc95000_timer_get_nsec()!! 
#endif



// --------------------------------
// Debug defines.  For debug purposes only.  Not required for normal operation.
//#define DEBUG_ENABLE_ILLEGAL_INSTR_ISR
#define DEBUG_ENABLE_FRAMECOUNTER


#define DEBUG_ENABLE_STARTOFFRAME_GPIO_TOGGLE
#define DEBUG_ENABLE_FRAMEERROR_GPIO_TOGGLE




// --------------------------------
/*
** 8.4.4 Core Watchdog Control Register 
*/
#define FXLC95000_WATCHDOG_DISABLED         0
#define FXLC95000_WATCHDOG_INITIALIZATION FXLC95000_WATCHDOG_DISABLED

#if (BSP_TIMER == BSP_TIMER_USE_TPM)
  #define BSP_TIMER_INTERRUPT_VECTOR                    (VectorNumber_Vtpm1ovf)
#elif (BSP_TIMER == BSP_TIMER_USE_PDB)
  #define BSP_TIMER_INTERRUPT_VECTOR                    (VectorNumber_Vpdb_a)
#else
  #error ERROR: Irq vector not defined because of unknown timer!
#endif


/*
** The I2C settings.
*/
#define BSP_I2C_CLOCK                                 (BSP_BUS_CLOCK_HZ)
#define BSP_I2C_MULT_VAL                              FXLC95XXX_IIC_MUL_1
#define BSP_I2C_MULT_IICF_BITS                        FXLC95XXX_IIC_IICF_MUL_1
#define BSP_I2C0_ADDRESS                              (0x6E)
#define BSP_I2C1_ADDRESS                              (0x6F)
#define BSP_I2C0_BAUD_RATE                            (100000)
#define BSP_I2C1_BAUD_RATE                            (100000)
#define BSP_I2C0_MODE                                 I2C_MODE_MASTER
#define BSP_I2C1_MODE                                 I2C_MODE_MASTER
#define BSP_I2C0_RX_BUFFER_SIZE                       (64)
#define BSP_I2C0_TX_BUFFER_SIZE                       (64)
#define BSP_I2C1_RX_BUFFER_SIZE                       (64)
#define BSP_I2C1_TX_BUFFER_SIZE                       (64)



/*
** Define the location of the hardware interrupt vector table
*/
extern uchar __VECTOR_TABLE_ROM_START[]; // defined in linker command file
extern uchar __VECTOR_TABLE_RAM_START[]; // defined in linker command file

#if MQX_ROM_VECTORS
    #define BSP_INTERRUPT_VECTOR_TABLE                    ((uint_32)__VECTOR_TABLE_ROM_START)
#else
    #define BSP_INTERRUPT_VECTOR_TABLE                    ((uint_32)__VECTOR_TABLE_RAM_START)
#endif


/*
** Define the range of interrupts for which the application can install
** isrs.
*/ 
#ifndef BSP_FIRST_INTERRUPT_VECTOR_USED                                                 
   #define BSP_FIRST_INTERRUPT_VECTOR_USED              VectorNumber_Vaccerr   
#endif

#ifndef BSP_LAST_INTERRUPT_VECTOR_USED                                                 
	#define BSP_LAST_INTERRUPT_VECTOR_USED               VectorNumber_VL1swi
#endif


#ifndef BSPCFG_ENABLE_CPP
   #define BSPCFG_ENABLE_CPP    0
#endif

/*----------------------------------------------------------------------
**                  IO DEVICE DRIVERS CONFIGURATION
*/

#ifndef BSPCFG_ENABLE_IO_SUBSYSTEM
   #define BSPCFG_ENABLE_IO_SUBSYSTEM  1
#endif

/* polled I2C0 device */
#ifndef BSPCFG_ENABLE_I2C0
#define BSPCFG_ENABLE_I2C0 1
#endif


/* int I2C0 device */
#ifndef BSPCFG_ENABLE_II2C0
#define BSPCFG_ENABLE_II2C0 0
#endif


/* GPIO device */
#ifndef BSPCFG_ENABLE_GPIODEV
#define BSPCFG_ENABLE_GPIODEV  1
#endif


/* PCFLASH device */
#ifndef BSPCFG_ENABLE_PCFLASH
#define BSPCFG_ENABLE_PCFLASH  1
#endif


/* CFM */
#ifndef BSPCFG_ENABLE_FLASHX
#define BSPCFG_ENABLE_FLASHX        1 
#endif

/*----------------------------------------------------------------------
**                  DEFAULT MQX INITIALIZATION DEFINITIONS
*/

/* Defined in link.xxx */
extern uchar __KERNEL_DATA_START[];
extern uchar __KERNEL_DATA_END[];
extern uchar __DEFAULT_PROCESSOR_NUMBER[];
extern uchar __DEFAULT_INTERRUPT_STACK_SIZE[];

#if MQX_USER_IRQ_STACK_SUPPORT
  extern uchar __DEFAULT_USER_IRQ_STACK_SIZE[];
#endif

#define BSP_DEFAULT_START_OF_KERNEL_MEMORY            ((pointer)__KERNEL_DATA_START)
#define BSP_DEFAULT_END_OF_KERNEL_MEMORY              ((pointer)__KERNEL_DATA_END)
#define BSP_DEFAULT_PROCESSOR_NUMBER                  ((uint_32)__DEFAULT_PROCESSOR_NUMBER)


#if MQX_USER_IRQ_STACK_SUPPORT
  #ifndef BSP_DEFAULT_USER_IRQ_STACK_SIZE
    #define BSP_DEFAULT_USER_IRQ_STACK_SIZE     ( (uint_32)__DEFAULT_USER_IRQ_STACK_SIZE ) 
  #endif
#endif

#ifndef BSP_DEFAULT_INTERRUPT_STACK_SIZE
   #define BSP_DEFAULT_INTERRUPT_STACK_SIZE              ((uint_32)__DEFAULT_INTERRUPT_STACK_SIZE)
#endif

        
#ifndef BSP_DEFAULT_MQX_HARDWARE_INTERRUPT_LEVEL_MAX
   #define BSP_DEFAULT_MQX_HARDWARE_INTERRUPT_LEVEL_MAX  (7L) 
#endif

#ifndef BSP_DEFAULT_MAX_MSGPOOLS
   #define BSP_DEFAULT_MAX_MSGPOOLS                      (1L)
#endif

#ifndef BSP_DEFAULT_MAX_MSGQS
   #define BSP_DEFAULT_MAX_MSGQS                         (2L)
#endif

#ifndef BSP_DEFAULT_IO_CHANNEL
   #if BSPCFG_ENABLE_TTYB
      #define BSP_DEFAULT_IO_CHANNEL                        "ttyb:"
      #define BSP_DEFAULT_IO_CHANNEL_DEFINED
   #elif BSPCFG_ENABLE_TTYA 
      #define BSP_DEFAULT_IO_CHANNEL                        "ttya:"
      #define BSP_DEFAULT_IO_CHANNEL_DEFINED
   #elif BSPCFG_ENABLE_ITTYB 
      #define BSP_DEFAULT_IO_CHANNEL                        "ittyb:"
      #define BSP_DEFAULT_IO_CHANNEL_DEFINED
   #elif BSPCFG_ENABLE_ITTYA 
      #define BSP_DEFAULT_IO_CHANNEL                        "ttya:"
      #define BSP_DEFAULT_IO_CHANNEL_DEFINED
   #else
         #define BSP_DEFAULT_IO_CHANNEL                      NULL
   #endif
#endif

#ifndef BSP_DEFAULT_IO_OPEN_MODE
    // This define used in mqx_init.c
   #define BSP_DEFAULT_IO_OPEN_MODE                      (pointer) 0
   //#define BSP_DEFAULT_IO_OPEN_MODE                      (pointer) (IO_SERIAL_XON_XOFF | IO_SERIAL_TRANSLATION | IO_SERIAL_ECHO)
#endif

/* 
** CFM internal flash
*/
#if BSPCFG_ENABLE_FLASHX
    #ifndef BSPCFG_FLASHX_SIZE
    #define BSPCFG_FLASHX_SIZE      0x4000
    #endif
#else
    #undef  BSPCFG_FLASHX_SIZE
    #define BSPCFG_FLASHX_SIZE      0x0
#endif


#ifdef __cplusplus
}
#endif

#endif
/* EOF */
